﻿Public Class BetterGradientButton
    Inherits Button
    Private gradientStop1, gradientStop2 As GradientStop

    Public Shared ReadOnly Color1Property As DependencyProperty =
        DependencyProperty.Register("Color1",
                                    GetType(Color),
                                    GetType(BetterGradientButton),
                                    New PropertyMetadata(Colors.Black, AddressOf OnColorChanged))

    Public Shared ReadOnly Color2Property As DependencyProperty =
        DependencyProperty.Register("Color2",
                                    GetType(Color),
                                    GetType(BetterGradientButton),
                                    New PropertyMetadata(Colors.White, AddressOf OnColorChanged))

    Public Sub New()
        Dim brush As New LinearGradientBrush()
        brush.StartPoint = New Point(0, 0)
        brush.EndPoint = New Point(1, 0)

        gradientStop1 = New GradientStop()
        gradientStop1.Offset = 0
        gradientStop1.Color = Color1
        brush.GradientStops.Add(gradientStop1)

        gradientStop2 = New GradientStop()
        gradientStop2.Offset = 1
        gradientStop2.Color = Color2
        brush.GradientStops.Add(gradientStop2)

        Foreground = brush
    End Sub

    Public Property Color1() As Color
        Set(ByVal value As Color)
            SetValue(Color1Property, value)
        End Set
        Get
            Return CType(GetValue(Color1Property), Color)
        End Get
    End Property

    Public Property Color2() As Color
        Set(ByVal value As Color)
            SetValue(Color2Property, value)
        End Set
        Get
            Return CType(GetValue(Color2Property), Color)
        End Get
    End Property

    Private Shared Sub OnColorChanged(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        Dim btn = TryCast(obj, BetterGradientButton)

        If args.Property Is Color1Property Then
            btn.gradientStop1.Color = CType(args.NewValue, Color)
        End If

        If args.Property Is Color2Property Then
            btn.gradientStop2.Color = CType(args.NewValue, Color)
        End If
    End Sub
End Class
